/* eslint-disable */
/**
 * This file was automatically generated by json-schema-to-typescript.
 * DO NOT MODIFY IT BY HAND. Instead, modify the source JSONSchema file,
 * and run json-schema-to-typescript to regenerate this file.
 */

/**
 * The type of the evaluation
 */
export type EvalTypeID = string;
/**
 * Model name. Must be set with a command line argument. For this eval, we currently recommend to only use models >= 2B parameters.
 */
export type ModelName = string;
/**
 * Random seed
 */
export type RandomSeed = number;
/**
 * F1 jump threshold
 */
export type F1JumpThreshold = number;
/**
 * Max k value
 */
export type MaxKValue = number;
/**
 * Prompt template
 */
export type PromptTemplate = string;
/**
 * Prompt token position
 */
export type PromptTokenPosition = number;
/**
 * LLM batch size. This is set by default in the main script, or it can be set with a command line argument.
 */
export type LLMBatchSize = number;
/**
 * LLM data type. This is set by default in the main script, or it can be set with a command line argument.
 */
export type LLMDataType = string;
/**
 * L1 decay for k-sparse probes.
 */
export type KSparseProbeL1Decay = number;
/**
 * Batch size for k-sparse probes.
 */
export type KSparseProbeBatchSize = number;
/**
 * Number of epochs for k-sparse probes.
 */
export type KSparseProbeNumberOfEpochs = number;
/**
 * A unique UUID identifying this specific eval run
 */
export type ID = string;
/**
 * The datetime of the evaluation in epoch milliseconds
 */
export type DateTimeEpochMs = number;
/**
 * Average of the absorption fraction scores across all letters
 */
export type MeanAbsorptionFractionScore = number;
/**
 * Average of the full absorption scores across all letters
 */
export type MeanFullAbsorptionScore = number;
/**
 * Average number of split features across all letters
 */
export type MeanNumberOfSplitFeatures = number;
/**
 * Standard deviation of the absorption fraction scores across all letters
 */
export type StandardDeviationOfAbsorptionFractionScore = number;
/**
 * Standard deviation of the full absorption scores across all letters
 */
export type StandardDeviationOfFullAbsorptionScore = number;
/**
 * Standard deviation of the number of split features across all letters
 */
export type StandardDeviationOfNumberOfSplitFeatures = number;
export type FirstLetter = string;
export type MeanAbsorptionFraction = number;
export type RateOfFullAbsorption = number;
export type NumFullAbsorption = number;
export type NumProbeTruePositives = number;
export type NumSplitFeatures = number;
/**
 * Each object is a stat on the first letter of the absorption.
 */
export type PerLetterAbsorptionResults = AbsorptionResultDetail[];
/**
 * The commit hash of the SAE Bench that ran the evaluation.
 */
export type SAEBenchCommitHash = string;
/**
 * The ID of the SAE in SAE Lens.
 */
export type SAELensID = string | null;
/**
 * The release ID of the SAE in SAE Lens.
 */
export type SAELensReleaseID = string | null;
/**
 * The version of SAE Lens that ran the evaluation.
 */
export type SAELensVersion = string | null;
/**
 * The configuration of the SAE (custom or from SAE Lens) that ran the evaluation. This should match the SAE Lens config schema.
 */
export type SAEConfigDict = {
  [k: string]: unknown;
} | null;

/**
 * The feature absorption evaluation looking at the first letter.
 */
export interface Absorption {
  eval_type_id?: EvalTypeID;
  eval_config: EvalConfigType;
  eval_id: ID;
  datetime_epoch_millis: DateTimeEpochMs;
  eval_result_metrics: ResultMetricsCategorized;
  eval_result_details?: PerLetterAbsorptionResults;
  sae_bench_commit_hash: SAEBenchCommitHash;
  sae_lens_id: SAELensID;
  sae_lens_release_id: SAELensReleaseID;
  sae_lens_version: SAELensVersion;
  sae_cfg_dict: SAEConfigDict;
  eval_result_unstructured?: unknown;
  [k: string]: unknown;
}
/**
 * The configuration of the evaluation.
 */
export interface EvalConfigType {
  model_name?: ModelName;
  random_seed?: RandomSeed;
  f1_jump_threshold?: F1JumpThreshold;
  max_k_value?: MaxKValue;
  prompt_template?: PromptTemplate;
  prompt_token_pos?: PromptTokenPosition;
  llm_batch_size?: LLMBatchSize;
  llm_dtype?: LLMDataType;
  k_sparse_probe_l1_decay?: KSparseProbeL1Decay;
  k_sparse_probe_batch_size?: KSparseProbeBatchSize;
  k_sparse_probe_num_epochs?: KSparseProbeNumberOfEpochs;
  [k: string]: unknown;
}
/**
 * The metrics of the evaluation, organized by category. Define your own categories and the metrics that go inside them.
 */
export interface ResultMetricsCategorized {
  mean: Mean;
  [k: string]: unknown;
}
/**
 * Mean metrics
 */
export interface Mean {
  mean_absorption_fraction_score: MeanAbsorptionFractionScore;
  mean_full_absorption_score: MeanFullAbsorptionScore;
  mean_num_split_features: MeanNumberOfSplitFeatures;
  std_dev_absorption_fraction_score: StandardDeviationOfAbsorptionFractionScore;
  std_dev_full_absorption_score: StandardDeviationOfFullAbsorptionScore;
  std_dev_num_split_features: StandardDeviationOfNumberOfSplitFeatures;
  [k: string]: unknown;
}
export interface AbsorptionResultDetail {
  first_letter: FirstLetter;
  mean_absorption_fraction: MeanAbsorptionFraction;
  full_absorption_rate: RateOfFullAbsorption;
  num_full_absorption: NumFullAbsorption;
  num_probe_true_positives: NumProbeTruePositives;
  num_split_features: NumSplitFeatures;
  [k: string]: unknown;
}
